﻿var incoming = {
    datatable: null,
    refreshDataTable: function () {
        incoming.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-incomingMailTable").a4datatable({
            ajaxAction: a4.getAction("GetIncomingMailConfigurations", "Distributions", "Admin"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Class": "id" },
                { "Name": "Customer", "Title": resources.Customer, "Data": "Customer", "Class": "v-name" },
                { "Name": "InboxEmail", "Title": resources.IncomingMailbox, "Data": "InboxEmail" },
                { "Name": "ServerAddress", "Title": resources.ServerAddress, "Data": "ServerAddress" },
                { "Name": "ServerPort", "Title": resources.ServerPort, "Data": "ServerPort" },
                { "Name": "Active", "Title": resources.Active, "Data": "Active", "Label": "ActiveLabel" },
                { "Name": "Protocol", "Title": resources.Protocol, "Data": "Protocol" },
                { "Name": "UseSSL", "Title": resources.UseSSL, "Data": "UseSSL", "Label": "UseSSLLabel" }
            ],
            defaultSorting: "Customer",
            toolBarItems: [{ "Action": "delete", "Label": resources.Delete }],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                if (action == "delete") {
                    incoming.deleteItems(ids);
                }
            },
            contextMenuItems: [
                { "Action": "test", "Label": resources.TestConnection },
                { "Divider": true },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "edit", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        modalDialog.showWindow(a4.getAction("IncomingMailEditor", "Distributions", "Admin", { id: row.Id }), 700, 650, { afterClose: function () { incoming.refreshDataTable(); } });
                        break;

                    case "delete":
                        incoming.deleteItems(row.Id);
                        break;

                    case "test":
                        incoming.testItem(row.Id, row.Protocol, row.ServerAddress, row.ServerPort, "", "", row.UseSSL);
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addIncoming", function () {
            modalDialog.showWindow(a4.getAction("IncomingMailEditor", "Distributions", "Admin"), 700, 650, { afterClose: function () { incoming.refreshDataTable(); } });
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteConfigurationsResources, function () {
            a4.callServerMethod(a4.getAction("DeleteIncoming", "Distributions", "Admin"), { itemIds: items },
                function (result) {
                    incoming.refreshDataTable();
                });
        }, 250, 400, true, { "count": itemsCount });
    },
    testItem: function (id, protocol, address, port, username, password, useSSL) {
        var protocolVal = protocol ? protocol : "POP3";
        var portVal = port ? port : 0;

        a4.callServerMethod(a4.getAction("TestIncomingConnection", "Distributions", "Admin"), { id: id, protocol: protocolVal, address: address, port: portVal, username: username, password: password, useSSL: useSSL },
            function (result) {
                if (result.success)
                    a4.showSuccessMessage(result.message);
                else
                    a4.showErrorMessage(result.message);

                if (id > 0)
                    incoming.refreshDataTable();
            });
    }
}

$(document).ready(function () {
    if ($(".v-incomingMailTable").length > 0) {
        incoming.initializeDataTable();
        incoming.bindEvents();
    }
});